<?php
require_once '../db_connect.php'; // Adjust path as needed

header('Content-Type: application/json');

// --- Authentication Placeholder ---
// In a real app, you'd verify the user's session/token and ensure they have owner privileges
// --- End Authentication Placeholder ---

$assetId = $_GET['assetId'] ?? null;

if ($assetId) {
    $sql = "SELECT 
                v.id AS assetId, 
                v.vehicle_identifier AS assetName, 
                v.location_text AS location, 
                v.status, 
                v.maintenance_due_date AS lastInspection 
            FROM vehicles v 
            WHERE v.id = ?"; // Using vehicles table
    
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    $stmt->bind_param("i", $assetId);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $asset = $result->fetch_assoc();
        if ($asset) {
            // Format date if needed
            if ($asset['lastInspection']) {
                $date = new DateTime($asset['lastInspection']);
                $asset['lastInspection'] = $date->format('Y-m-d');
            }
            echo json_encode($asset);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Asset not found.']);
        }
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(400);
    echo json_encode(['error' => 'Asset ID is required.']);
}

$conn->close();
?>