<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// --- Authentication Placeholder ---
// In a real app, you'd verify the user's session/token and ensure they have owner privileges
// --- End Authentication Placeholder ---

// No specific input needed for this example (fetching all reports)
// In a real app, you might want to add filtering options (by type, date range, etc.)

$sql = "SELECT 
            r.id, 
            r.title, 
            r.type, 
            u.name AS generatedBy, 
            r.created_at,
            r.data
        FROM reports r
        JOIN users u ON r.generated_by = u.id
        ORDER BY r.created_at DESC";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
    exit();
}

if ($stmt->execute()) {
    $result = $stmt->get_result();
    $reports = [];
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        // Format date if needed
        if ($row['created_at']) {
            $date = new DateTime($row['created_at']);
            $row['created_at'] = $date->format('Y-m-d');
        }
        $reports[] = $row;
    }
    echo json_encode($reports);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>