<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
// $user_yard_id = $_SESSION['yard_id'] ?? null; // Wash crew might be tied to a yard
$user_id = 8; // Hardcoding Wash Crew One (ID 8) for now
$user_role = 'wash_crew'; 
// if (!$user_id || $user_role !== 'wash_crew') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'GET') {
    // Fetch Completed wash jobs 
    // Optionally filter by assigned_crew_id or yard if needed
    $sql = "SELECT 
                wj.id AS wash_job_db_id, 
                wj.job_identifier, 
                wj.location_text, 
                wj.status, 
                wj.completion_time, 
                wj.notes,
                v.vehicle_identifier,
                vt.name AS vehicle_type_name
            FROM wash_jobs wj
            JOIN vehicles v ON wj.vehicle_id = v.id
            LEFT JOIN vehicle_types vt ON v.vehicle_type_id = vt.id
            WHERE wj.status = 'Completed' ";
            
    // Example filtering by crew member:
    // $sql .= " AND wj.assigned_crew_id = ? "; 
    
    // Example filtering by yard:
    // if ($user_yard_id) {
    //     $sql .= " AND v.yard_id = ? "; // Assuming vehicles table has yard_id
    // }
    
    $sql .= " ORDER BY wj.completion_time DESC"; // Show most recent first
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    // If filtering: $stmt->bind_param("i", $user_id); // Or $user_yard_id

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $jobs = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
             // Format time if needed
             if ($row['completion_time']) {
                 $dt = new DateTime($row['completion_time']);
                 $row['completion_time'] = $dt->format('Y-m-d H:i:s'); // Or other format
             }
            $jobs[] = $row;
        }
        echo json_encode($jobs);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>