<?php
require_once '../db_connect.php'; // Include connection just in case

header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
// $user_name_session = $_SESSION['user_name'] ?? null; 
// $user_email = $_SESSION['user_email'] ?? null; 
$user_id = 8; // Hardcoding Wash Crew One (ID 8) for now
$user_role = 'wash_crew'; 
// if (!$user_id || $user_role !== 'wash_crew') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // Basic validation
    $subject = $data['subject'] ?? null;
    $location = $data['location'] ?? null;
    $name = $data['name'] ?? null; // Ideally get from session ($user_name_session)
    $description = $data['description'] ?? null;
    $role = $data['role'] ?? 'wash_crew'; 

    if ($subject && $location && $name && $description) { 
        
        // --- Placeholder for actual support request handling ---
        // 1. Store in a database table (e.g., `support_tickets` or `equipment_issues`)
        /*
        $sql = "INSERT INTO support_tickets (subject, name, email, description, role, location_info, status, created_at, user_id) 
                VALUES (?, ?, ?, ?, ?, ?, 'new', NOW(), ?)";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            // Assuming email is fetched from session/auth
            $stmt->bind_param("ssssssi", $subject, $name, $user_email, $description, $role, $location, $user_id); 
            $stmt->execute();
            $stmt->close();
        } else {
             error_log("Failed to prepare statement for support ticket: " . $conn->error);
        }
        */

        // 2. Send an email notification (e.g., to Yard Manager or Maintenance)
        /*
        $to = "yard.manager@visapp.com"; // Or maintenance@visapp.com
        $email_subject = "New Wash Crew Report ($role): " . $subject;
        $headers = "From: no-reply@visapp.com\r\n";
        // $headers .= "Reply-To: " . $user_email . "\r\n"; // Use session email if available
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        
        $email_body = "New wash crew report received:\n\n";
        $email_body .= "From: " . $name . "\n"; // Name might also come from session
        $email_body .= "Location: " . $location . "\n";
        $email_body .= "Subject: " . $subject . "\n\n";
        $email_body .= "Description:\n" . $description;

        // Use mail() function or a library
        // mail($to, $email_subject, $email_body, $headers); 
        */
        
        // For now, just return success
        echo json_encode(['success' => true, 'message' => 'Report received.']);
        
    } else {
        http_response_code(400); // Bad Request
        echo json_encode(['error' => 'Invalid or missing data. Please fill all required fields.']);
    }

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close(); // Close connection if it was used
?>