<?php
// Include database connection
require_once 'db_connect.php';

// Set headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: text/html");

echo "<h1>Adding Sample WashCrew Users</h1>";

try {
    // Sample WashCrew users data
    $users = [
        [
            'name' => 'John Washman',
            'email' => 'john.washman@example.com',
            'password' => password_hash('password123', PASSWORD_DEFAULT),
            'role' => 'washcrew',
            'status' => 'active',
            'created_at' => '2023-11-15 10:30:00',
            'created_by' => 3 // Yard Manager ID
        ],
        [
            'name' => 'Sarah Cleaner',
            'email' => 'sarah.cleaner@example.com',
            'password' => password_hash('password123', PASSWORD_DEFAULT),
            'role' => 'washcrew',
            'status' => 'active',
            'created_at' => '2023-11-20 14:45:00',
            'created_by' => 3 // Yard Manager ID
        ],
        [
            'name' => 'Mike Polisher',
            'email' => 'mike.polisher@example.com',
            'password' => password_hash('password123', PASSWORD_DEFAULT),
            'role' => 'washcrew',
            'status' => 'inactive',
            'created_at' => '2023-10-05 09:15:00',
            'created_by' => 3 // Yard Manager ID
        ],
        [
            'name' => 'Lisa Detailer',
            'email' => 'lisa.detailer@example.com',
            'password' => password_hash('password123', PASSWORD_DEFAULT),
            'role' => 'washcrew',
            'status' => 'pending',
            'created_at' => '2023-12-01 11:20:00',
            'created_by' => 3 // Yard Manager ID
        ],
        [
            'name' => 'David Washer',
            'email' => 'david.washer@example.com',
            'password' => password_hash('password123', PASSWORD_DEFAULT),
            'role' => 'washcrew',
            'status' => 'active',
            'created_at' => '2023-11-10 08:30:00',
            'created_by' => 3 // Yard Manager ID
        ]
    ];
    
    // Insert each user if they don't already exist
    $addedCount = 0;
    foreach ($users as $user) {
        // Check if user already exists
        $checkStmt = $pdo->prepare("SELECT id FROM users WHERE email = :email");
        $checkStmt->bindParam(':email', $user['email']);
        $checkStmt->execute();
        
        if ($checkStmt->rowCount() === 0) {
            // User doesn't exist, insert them
            $sql = "INSERT INTO users (name, email, password, role, status, created_at, created_by) 
                    VALUES (:name, :email, :password, :role, :status, :created_at, :created_by)";
            
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':name', $user['name']);
            $stmt->bindParam(':email', $user['email']);
            $stmt->bindParam(':password', $user['password']);
            $stmt->bindParam(':role', $user['role']);
            $stmt->bindParam(':status', $user['status']);
            $stmt->bindParam(':created_at', $user['created_at']);
            $stmt->bindParam(':created_by', $user['created_by']);
            
            if ($stmt->execute()) {
                echo "<p style='color:green'>Added user: {$user['name']} ({$user['email']})</p>";
                $addedCount++;
            } else {
                echo "<p style='color:red'>Failed to add user: {$user['name']} ({$user['email']})</p>";
            }
        } else {
            echo "<p style='color:blue'>User already exists: {$user['name']} ({$user['email']})</p>";
        }
    }
    
    echo "<h2>Summary</h2>";
    echo "<p>Added $addedCount new WashCrew users to the database.</p>";
    
    // Display all WashCrew users in the database
    $sql = "SELECT id, name, email, role, status, created_at, created_by FROM users WHERE role = 'washcrew' ORDER BY created_at DESC";
    $stmt = $pdo->query($sql);
    $washcrewUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>All WashCrew Users in Database</h2>";
    echo "<table border='1' cellpadding='5' cellspacing='0'>";
    echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Status</th><th>Created At</th><th>Created By</th></tr>";
    
    foreach ($washcrewUsers as $user) {
        echo "<tr>";
        echo "<td>{$user['id']}</td>";
        echo "<td>{$user['name']}</td>";
        echo "<td>{$user['email']}</td>";
        echo "<td>{$user['status']}</td>";
        echo "<td>{$user['created_at']}</td>";
        echo "<td>{$user['created_by']}</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
} catch (PDOException $e) {
    echo "<p style='color:red'>Database error: " . $e->getMessage() . "</p>";
}
?>
