<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection
require_once 'db_connect.php';

// Get request method
$method = $_SERVER['REQUEST_METHOD'];

// Check for token in headers - disabled for testing
// $headers = getallheaders();
// $token = isset($headers['Authorization']) ? $headers['Authorization'] : '';

// Verify token (simplified for demo)
// In a production environment, implement proper JWT validation
// if (empty($token)) {
//     echo json_encode(['error' => 'Authentication required']);
//     exit;
// }

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

if ($method === 'GET') {
    try {
        // Query to fetch assignments with related information
        $sql = "SELECT
                    da.id,
                    da.assignment_identifier,
                    da.type,
                    da.origin_location,
                    da.destination_location,
                    da.status,
                    da.scheduled_time,
                    da.start_time,
                    da.completion_time,
                    da.created_at,
                    da.updated_at,
                    u.id AS driver_id,
                    u.name AS driver_name,
                    u.email AS driver_email,
                    v.id AS vehicle_id,
                    v.vehicle_identifier
                FROM
                    dispatch_assignments da
                LEFT JOIN
                    users u ON da.driver_id = u.id
                LEFT JOIN
                    vehicles v ON da.vehicle_id = v.id
                ORDER BY
                    CASE da.status
                        WHEN 'Active' THEN 1
                        WHEN 'Pending' THEN 2
                        WHEN 'Completed' THEN 3
                        WHEN 'Cancelled' THEN 4
                        ELSE 5
                    END,
                    da.scheduled_time ASC,
                    da.created_at DESC";

        $stmt = $pdo->prepare($sql);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Format the data for frontend
            $formattedAssignments = [];
            foreach ($assignments as $assignment) {
                // Format dates for better readability
                $scheduledTime = $assignment['scheduled_time'] ? date('Y-m-d H:i', strtotime($assignment['scheduled_time'])) : null;
                $startTime = $assignment['start_time'] ? date('Y-m-d H:i', strtotime($assignment['start_time'])) : null;
                $completionTime = $assignment['completion_time'] ? date('Y-m-d H:i', strtotime($assignment['completion_time'])) : null;

                $formattedAssignments[] = [
                    'id' => $assignment['id'],
                    'assignment_identifier' => $assignment['assignment_identifier'],
                    'type' => $assignment['type'],
                    'origin_location' => $assignment['origin_location'],
                    'destination_location' => $assignment['destination_location'],
                    'status' => $assignment['status'],
                    'scheduled_time' => $scheduledTime,
                    'start_time' => $startTime,
                    'completion_time' => $completionTime,
                    'driver_id' => $assignment['driver_id'],
                    'driver_name' => $assignment['driver_name'],
                    'driver_identifier' => $assignment['driver_id'], // Using ID as identifier for simplicity
                    'vehicle_id' => $assignment['vehicle_id'],
                    'vehicle_identifier' => $assignment['vehicle_identifier'],
                    'created_at' => $assignment['created_at'],
                    'updated_at' => $assignment['updated_at']
                ];
            }

            echo json_encode($formattedAssignments);
        } else {
            // If no assignments found, return empty array
            echo json_encode([]);
        }
    } catch (PDOException $e) {
        echo json_encode(['error' => 'Failed to fetch assignments: ' . $e->getMessage()]);
    }
} elseif ($method === 'POST') {
    try {
        // Get POST data
        $data = json_decode(file_get_contents("php://input"), true);

        // Validate required fields
        $requiredFields = ['driver_id', 'vehicle_id', 'type', 'origin_location', 'destination_location', 'status'];
        foreach ($requiredFields as $field) {
            if (!isset($data[$field]) || empty($data[$field])) {
                echo json_encode(['error' => "Missing required field: $field"]);
                exit;
            }
        }

        // Generate a unique assignment identifier (e.g., A009)
        $stmt = $pdo->query("SELECT MAX(CAST(SUBSTRING(assignment_identifier, 2) AS UNSIGNED)) as max_id FROM dispatch_assignments");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $nextId = ($result['max_id'] ?? 0) + 1;
        $assignmentIdentifier = 'A' . str_pad($nextId, 3, '0', STR_PAD_LEFT);

        // Insert new assignment
        $sql = "INSERT INTO dispatch_assignments
                (assignment_identifier, driver_id, vehicle_id, type, origin_location, destination_location,
                status, scheduled_time, dispatcher_id)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $assignmentIdentifier,
            $data['driver_id'],
            $data['vehicle_id'],
            $data['type'],
            $data['origin_location'],
            $data['destination_location'],
            $data['status'],
            $data['scheduled_time'] ?? null,
            $data['dispatcher_id'] ?? null
        ]);

        echo json_encode([
            'success' => true,
            'message' => 'Assignment created successfully',
            'assignment_identifier' => $assignmentIdentifier
        ]);
    } catch (PDOException $e) {
        echo json_encode(['error' => 'Failed to create assignment: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'Method not allowed']);
}
?>
