<?php
// Database connection parameters
$host = 'localhost';
$username = 'root';
$password = '';

try {
    // Connect to MySQL without specifying a database
    $pdo = new PDO("mysql:host=$host", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Create the database if it doesn't exist
    $dbname = 'vehicle_inspection_system';
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci");
    
    echo "Database '$dbname' created or already exists.\n";
    
    // Select the database
    $pdo->exec("USE `$dbname`");
    
    // Create tables
    include 'setup_tables.php';
    
    echo "Database setup completed successfully.\n";
    
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>
