<?php
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require_once 'db_connect.php';

$userId = verifyRole($conn, 'owner');
if (isset($_POST['vehicle_id']) && isset($_POST['frequency']) && isset($_POST['last_inspected']) && isset($_POST['next_inspection'])) {
    $vehicle_id = $_POST['vehicle_id'];
    $frequency = $_POST['frequency'];
    $last_inspected = $_POST['last_inspected'];
    $next_inspection = $_POST['next_inspection'];
    $stmt = $conn->prepare("INSERT INTO inspection_schedules (vehicle_id, frequency, last_inspected, next_inspection) VALUES (?, ?, ?, ?)");
    $stmt->execute([$vehicle_id, $frequency, $last_inspected, $next_inspection]);
    echo json_encode(['success' => true, 'message' => 'Schedule created', 'data' => ['id' => $conn->lastInsertId(), 'vehicle_id' => $vehicle_id, 'frequency' => $frequency, 'last_inspected' => $last_inspected, 'next_inspection' => $next_inspection]]);
} else {
    echo json_encode(['success' => false, 'message' => 'All fields required']);
}