<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request for CORS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    // Headers are already set at the top or in db_connect.php
    http_response_code(200); // Respond with OK status
    exit; // Stop script execution for OPTIONS request
}

require_once __DIR__ . '/db_connect.php'; // Use __DIR__ for reliability

// Check if $pdo is available after including db_connect.php
if (!isset($pdo) || !$pdo instanceof PDO) {
     http_response_code(500);
     echo json_encode([
         'success' => false,
         'message' => 'Database connection object ($pdo) is not available in getDashboardSummary.php.'
     ]);
     exit;
}

try {
    // Verify role using the $pdo connection
    // Note: Ensure the 'verifyRole' function and the required role 'owner' are correct for this context.
    // $userId = verifyRole($pdo, 'owner'); // Use $pdo. Uncomment if role verification is needed here.

    // Fetch total inspections
    $stmtInspections = $pdo->prepare("SELECT COUNT(*) as total FROM inspections"); // Use $pdo
    $stmtInspections->execute();
    $totalInspections = $stmtInspections->fetchColumn(); // fetchColumn is simpler for single value

    // Fetch total users
    $stmtUsers = $pdo->prepare("SELECT COUNT(*) as total FROM users"); // Use $pdo
    $stmtUsers->execute();
    $totalUsers = $stmtUsers->fetchColumn();

    // Fetch total vehicles
    $stmtVehicles = $pdo->prepare("SELECT COUNT(*) as total FROM vehicles"); // Use $pdo
    $stmtVehicles->execute();
    $totalVehicles = $stmtVehicles->fetchColumn();

    // Prepare summary data
    $summaryData = [
        'totalInspections' => (int)$totalInspections, // Cast to int
        'financials' => '$0', // Placeholder value
        'totalUsers' => (int)$totalUsers,
        'totalVehicles' => (int)$totalVehicles // Include total vehicles
    ];

    echo json_encode(['success' => true, 'data' => $summaryData]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error in getDashboardSummary: ' . $e->getMessage()
    ]);
} catch (Exception $e) { // Catch potential errors from verifyRole if uncommented
    if (http_response_code() === 200) {
       http_response_code(401);
    }
    // Error message is already echoed by verifyRole
}
