<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Database connection configuration
// Use require_once for robustness and __DIR__ for path clarity
require_once __DIR__ . '/db_connect.php'; 

// Check if $pdo was successfully defined after require_once
if (!isset($pdo) || !$pdo instanceof PDO) {
     http_response_code(500);
     echo json_encode([
         'success' => false,
         'message' => 'Database connection object ($pdo) is not available after including db_connect.php. Check db_connect.php for connection errors or script exit points.'
     ]);
     exit;
}

try {
    // SQL query to fetch inspection history
    $query = "
        SELECT 
            i.inspection_date AS date,
            v.name AS assetName,
            u.name AS inspectorName,
            i.status AS status
        FROM inspections i
        JOIN vehicles v ON i.vehicle_id = v.id
        JOIN users u ON i.inspector_id = u.id
        ORDER BY i.inspection_date DESC
    ";
    
    // Prepare and execute the query
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $inspections = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return success response with data
    echo json_encode([
        'success' => true,
        'data' => $inspections
    ]);

} catch (PDOException $e) {
    // Return error response if something goes wrong
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error fetching inspection history: ' . $e->getMessage(),
        'data' => [] // Ensure data is always an array, even on error
    ]);
}
?>
