<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

require_once 'db_connect.php';

$userId = verifyRole($conn, 'owner');
$stmt = $conn->prepare("SELECT s.id, s.vehicle_id, v.name AS vehicle_name, s.frequency, s.last_inspected, s.next_inspection FROM inspection_schedules s JOIN vehicles v ON s.vehicle_id = v.id");
$stmt->execute();
$schedules = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo json_encode(['success' => true, 'data' => $schedules]);