<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request for CORS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    // Headers are already set at the top or in db_connect.php
    http_response_code(200); // Respond with OK status
    exit; // Stop script execution for OPTIONS request
}

require_once __DIR__ . '/db_connect.php'; // Use __DIR__ for reliability

// Check if $pdo is available after including db_connect.php
if (!isset($pdo) || !$pdo instanceof PDO) {
     http_response_code(500);
     echo json_encode([
         'success' => false,
         'message' => 'Database connection object ($pdo) is not available in getYardVehicles.php.'
     ]);
     exit;
}

try {
    // Verify role using the $pdo connection
    // Note: Ensure the 'verifyRole' function and the required role 'owner' are correct for this context.
    // $userId = verifyRole($pdo, 'owner'); // Use $pdo. Uncomment if role verification is needed here.

    // Prepare and execute the query using $pdo
    $stmt = $pdo->prepare("SELECT `id`, `name`, `plate`, `image`, `status` FROM `vehicles`"); // Added status based on previous files
    $stmt->execute();
    $vehicles = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['success' => true, 'data' => $vehicles]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error in getYardVehicles: ' . $e->getMessage(),
        'data' => [] // Ensure data is always an array on error
    ]);
} catch (Exception $e) { // Catch potential errors from verifyRole if uncommented
    // Error message might be echoed by verifyRole, but ensure consistent response format
    if (http_response_code() === 200) { // Check if status code wasn't already set
       http_response_code(401); // Set appropriate error code if not already set
    }
     // Echo consistent error format
     echo json_encode([
        'success' => false,
        'message' => 'Role verification or other error in getYardVehicles: ' . $e->getMessage(),
        'data' => [] // Ensure data is always an array
    ]);
}
