<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

require_once 'db_connect.php';

$userId = verifyRole($conn, 'owner');
if (isset($_POST['email']) && isset($_POST['role']) && isset($_POST['name'])) {
    $email = $_POST['email'];
    $role = $_POST['role'];
    $name = $_POST['name'];
    $password = password_hash('default', PASSWORD_BCRYPT);
    $region_id = isset($_POST['region_id']) && !empty($_POST['region_id']) ? $_POST['region_id'] : null;
    $yard_id = isset($_POST['yard_id']) && !empty($_POST['yard_id']) ? $_POST['yard_id'] : null;
    $stmt = $conn->prepare("INSERT INTO users (email, password, role, name, region_id, yard_id) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$email, $password, $role, $name, $region_id, $yard_id]);
    echo json_encode(['success' => true, 'message' => 'User invited successfully', 'data' => ['id' => $conn->lastInsertId(), 'email' => $email, 'role' => $role, 'name' => $name, 'region_id' => $region_id, 'yard_id' => $yard_id]]);
} else {
    echo json_encode(['success' => false, 'message' => 'Email, role, and name are required']);
}