<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Database connection configuration
$host = 'localhost';
$dbname = 'vehicle_inspection_db'; // Replace with your database name
$username = 'root'; // Replace with your DB username
$password = ''; // Replace with your DB password

// Function to verify token (simplified example)
function verifyToken($token) {
    // In a real application, validate the token against a stored session or user table
    // For simplicity, assume any non-empty token is valid
    return !empty($token);
}

try {
    // Check if the request method is POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'Method Not Allowed']);
        exit;
    }

    // Get the Authorization token from headers
    $headers = apache_request_headers();
    $token = isset($headers['Authorization']) ? $headers['Authorization'] : '';

    // Verify token
    if (!verifyToken($token)) {
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Unauthorized: Invalid or missing token']);
        exit;
    }

    // Get POST data
    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input || !isset($input['vehicleId']) || !isset($input['status'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Bad Request: vehicleId and status are required']);
        exit;
    }

    $vehicleId = $input['vehicleId'];
    $status = $input['status'];

    // Validate inputs
    if (!is_numeric($vehicleId) || empty($status)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Bad Request: Invalid vehicleId or status']);
        exit;
    }

    // Establish database connection
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Prepare and execute the update query
    $query = "UPDATE vehicles SET status = :status WHERE id = :vehicleId";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':status', $status, PDO::PARAM_STR);
    $stmt->bindParam(':vehicleId', $vehicleId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if any rows were affected
    if ($stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Vehicle status updated successfully',
            'data' => ['vehicleId' => $vehicleId, 'status' => $status]
        ]);
    } else {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'Vehicle not found']);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}
?>