<?php
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'vehicle_inspection_system';

header("Access-Control-Allow-Origin: http://localhost:3000");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); // Use $pdo here
} catch (PDOException $e) {
    // It's often better to log the error server-side than echo it directly for security.
    // For now, we keep the echo for debugging, but consider changing this in production.
    echo json_encode(array('success' => false, 'message' => "Database Connection failed: " . $e->getMessage()));
    // Remove exit; let the calling script handle the missing $pdo
    // exit; 
}

// This function should use the $pdo connection object established above.
function validateToken($pdo) { // Changed parameter name
    $headers = getallheaders();
    // Extract Bearer token if present
    $authHeader = $headers['Authorization'] ?? '';
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $token = $matches[1];
    } else {
        $token = ''; // No valid Bearer token found
    }

    if (empty($token)) {
        http_response_code(401);
        echo json_encode(array('success' => false, 'message' => 'Authorization token not found'));
        exit;
    }

    try {
        // Example token verification (replace with your actual logic, e.g., checking a sessions table)
        $stmt = $pdo->prepare("SELECT user_id FROM sessions WHERE token = ? AND expires_at > NOW()"); // Use $pdo
        $stmt->execute([$token]);
        $session = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$session) {
            http_response_code(401);
            echo json_encode(array('success' => false, 'message' => 'Invalid or expired token'));
            exit;
        }
        // Optionally return user_id or other relevant info if needed by the calling script
        // return $session['user_id']; 
        return true; // Token is valid
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(array('success' => false, 'message' => 'Token validation database error: ' . $e->getMessage()));
        // Remove exit; let the calling script handle potential issues
        // exit; 
    }
    // Removed redundant return true; as the function exits on error or returns true implicitly if validation passes
}
