<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'db_connect.php';

// Set content type to JSON
header('Content-Type: application/json');

try {
    // Get all users
    $stmt = $pdo->prepare("SELECT id, name, email, role, status, created_at FROM users ORDER BY id DESC");
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get table structure
    $structureStmt = $pdo->prepare("DESCRIBE users");
    $structureStmt->execute();
    $structure = $structureStmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get washcrew users
    $washcrewStmt = $pdo->prepare("SELECT id, name, email, role, status, created_at FROM users WHERE role = 'washcrew' ORDER BY id DESC");
    $washcrewStmt->execute();
    $washcrewUsers = $washcrewStmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'table_structure' => $structure,
        'all_users' => $users,
        'washcrew_users' => $washcrewUsers,
        'user_count' => count($users),
        'washcrew_count' => count($washcrewUsers)
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>
