<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once '../db_connect.php';

try {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $data = json_decode(file_get_contents("php://input"), true);
        $driver_id = isset($data['driver_id']) ? intval($data['driver_id']) : 0;

        if (!$driver_id) {
            throw new Exception('Driver ID is required');
        }

        $stmt = $pdo->prepare("
            SELECT m.*, 
                   u_sender.name as sender_name,
                   u_receiver.name as receiver_name
            FROM messages m
            JOIN users u_sender ON m.sender_id = u_sender.id
            JOIN users u_receiver ON m.receiver_id = u_receiver.id
            WHERE (sender_id = ? OR receiver_id = ?)
            ORDER BY m.timestamp DESC
            LIMIT 50
        ");
        
        $stmt->execute([$driver_id, $driver_id]);
        $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode([
            'success' => true,
            'messages' => $messages
        ]);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>