<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
error_log("Request Method: " . $_SERVER['REQUEST_METHOD']);
error_log("Request Parameters: " . json_encode($_REQUEST));

$vehicleTypeId = $_GET['vehicleTypeId'];
error_log("Vehicle Type ID: " . $vehicleTypeId);

// Placeholder for database query
$query = "SELECT c.* FROM categories c INNER JOIN vehicle_type_categories vtc ON c.id = vtc.category_id WHERE vtc.vehicle_type_id = " . $vehicleTypeId;
error_log("Query: " . $query);

// TODO: Execute the query and return the results
header("Content-Type: application/json");
require '../db_connect.php'; // Include the database connection
error_log("db_connect.php included successfully");

// Function to get all categories with their subcategories
function getInspectionCategories($conn) {
    try {
        $query = "
            SELECT c.id AS category_id, c.name AS category_name, 
                   s.id AS subcategory_id, s.name AS subcategory_name
            FROM categories c
            LEFT JOIN subcategories s ON c.id = s.category_id
            ORDER BY c.id, s.id
        ";
        $query = "SELECT c.* FROM categories c INNER JOIN vehicle_type_categories vtc ON c.id = vtc.category_id WHERE vtc.vehicle_type_id = :vehicleTypeId";
        error_log("Executing Query: " . $query);
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':vehicleTypeId', $vehicleTypeId, PDO::PARAM_INT);
        $stmt->execute();
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Organize data into a structured format
        $categories = [];
        foreach ($results as $row) {
            $categoryId = $row['category_id'];
            if (!isset($categories[$categoryId])) {
                $categories[$categoryId] = [
                    'id' => $categoryId,
                    'name' => $row['category_name'],
                    'subcategories' => []
                ];
            }
            if ($row['subcategory_id']) {
                $categories[$categoryId]['subcategories'][] = [
                    'id' => $row['subcategory_id'],
                    'name' => $row['subcategory_name']
                ];
            }
        }
        return ['success' => true, 'data' => array_values($categories)]; // Convert to indexed array for JSON
    } catch (PDOException $e) {
        error_log("PDOException in getInspectionCategories: " . $e->getMessage());
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

// Handle GET request
error_log("Request Method (inside GET check): " . $_SERVER['REQUEST_METHOD']);
error_log("Action Parameter Set: " . isset($_GET['action']));
if (isset($_GET['action'])) {
    error_log("Action Parameter Value: " . $_GET['action']);
}
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'getInspectionCategories') {
    $categories = getInspectionCategories($conn);
    error_log("Categories: " . json_encode($categories));
    echo json_encode($categories);
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid request']);
}
?>