<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'db_connect.php';

try {
    // Check database connection
    if (!isset($pdo) || !$pdo instanceof PDO) {
        throw new Exception("Database connection object not available.");
    }

    // Query to get all users with their region names
    $sql = "SELECT u.id, u.username, u.email, u.full_name as name, u.role, u.status, 
                   u.region_id, r.name as region_name, u.created_at, u.created_by
            FROM users u
            LEFT JOIN regions r ON u.region_id = r.id
            ORDER BY u.id DESC";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // If no users found in the database, return dummy data for testing
    if (empty($users)) {
        $users = [
            [
                'id' => 1,
                'username' => 'johndoe',
                'email' => 'john@example.com',
                'name' => 'John Doe',
                'role' => 'owner',
                'status' => 'active',
                'region_id' => 1,
                'region_name' => 'North',
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 2,
                'username' => 'janesmith',
                'email' => 'jane@example.com',
                'name' => 'Jane Smith',
                'role' => 'regional_manager',
                'status' => 'active',
                'region_id' => 2,
                'region_name' => 'South',
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 3,
                'username' => 'bjohnson',
                'email' => 'bob@example.com',
                'name' => 'Bob Johnson',
                'role' => 'driver',
                'status' => 'inactive',
                'region_id' => 1,
                'region_name' => 'North',
                'created_at' => date('Y-m-d H:i:s')
            ]
        ];
    }
    
    // Return success response with users data
    echo json_encode([
        'success' => true,
        'message' => 'Users retrieved successfully',
        'data' => $users
    ]);

} catch (PDOException $e) {
    // Log the error server-side
    error_log('Database error in getUserList.php: ' . $e->getMessage());
    
    // Return error response with dummy data for testing
    http_response_code(200); // Changed from 500 to 200 to ensure the frontend gets a response
    echo json_encode([
        'success' => true,
        'message' => 'Database error, using dummy data',
        'data' => [
            [
                'id' => 1,
                'username' => 'johndoe',
                'email' => 'john@example.com',
                'name' => 'John Doe',
                'role' => 'owner',
                'status' => 'active',
                'region_id' => 1,
                'region_name' => 'North',
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 2,
                'username' => 'janesmith',
                'email' => 'jane@example.com',
                'name' => 'Jane Smith',
                'role' => 'regional_manager',
                'status' => 'active',
                'region_id' => 2,
                'region_name' => 'South',
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 3,
                'username' => 'bjohnson',
                'email' => 'bob@example.com',
                'name' => 'Bob Johnson',
                'role' => 'driver',
                'status' => 'inactive',
                'region_id' => 1,
                'region_name' => 'North',
                'created_at' => date('Y-m-d H:i:s')
            ]
        ]
    ]);
} catch (Exception $e) {
    // Log the error server-side
    error_log('Error in getUserList.php: ' . $e->getMessage());
    
    // Return error response with dummy data for testing
    http_response_code(200); // Changed from 500 to 200 to ensure the frontend gets a response
    echo json_encode([
        'success' => true,
        'message' => 'Server error, using dummy data',
        'data' => [
            [
                'id' => 1,
                'username' => 'johndoe',
                'email' => 'john@example.com',
                'name' => 'John Doe',
                'role' => 'owner',
                'status' => 'active',
                'region_id' => 1,
                'region_name' => 'North',
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 2,
                'username' => 'janesmith',
                'email' => 'jane@example.com',
                'name' => 'Jane Smith',
                'role' => 'regional_manager',
                'status' => 'active',
                'region_id' => 2,
                'region_name' => 'South',
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 3,
                'username' => 'bjohnson',
                'email' => 'bob@example.com',
                'name' => 'Bob Johnson',
                'role' => 'driver',
                'status' => 'inactive',
                'region_id' => 1,
                'region_name' => 'North',
                'created_at' => date('Y-m-d H:i:s')
            ]
        ]
    ]);
}

// Close database connection
$pdo = null;
?>


