<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require_once 'db_connect.php';

try {
    $created_by = isset($_GET['created_by']) ? intval($_GET['created_by']) : null;
    
    // Prepare the SQL query
    $sql = "SELECT id, name, email, role, status, created_at, created_by 
            FROM users 
            WHERE (role = 'washcrew' OR role = 'wash_crew')";
    
    // Add created_by filter if provided
    if ($created_by !== null) {
        $sql .= " AND created_by = :created_by";
    }
    
    // Order by creation date
    $sql .= " ORDER BY created_at DESC";
    
    $stmt = $pdo->prepare($sql);
    
    if ($created_by !== null) {
        $stmt->bindParam(':created_by', $created_by, PDO::PARAM_INT);
    }
    
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'data' => $users
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>

