<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection
require_once 'db_connect.php';

// Get request body
$data = json_decode(file_get_contents('php://input'), true);

// Check if required fields are provided
if (!isset($data['username']) || !isset($data['pin'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Username and PIN are required']);
    exit;
}

$username = $data['username'];
$pin = $data['pin']; // This should be already hashed from the frontend

try {
    // Find user by username in users_new table
    $stmt = $pdo->prepare("SELECT * FROM users_new WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        // User not found, try with email
        $stmt = $pdo->prepare("SELECT * FROM users_new WHERE email = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
    }

    if ($user) {
        // Verify PIN
        if ($pin === $user['pin']) {
            // Prepare user data for response
            $userData =  [
                'id' => $user['id'],
                'username' => $user['username'],
                'email' => $user['email'],
                'full_name' => $user['full_name'],
                'role' => $user['role'],
                'company' => $user['company'],
                'created_at' => $user['created_at']
            ];

            // Generate a token
            $token = bin2hex(random_bytes(32));

            // Return success response
            echo json_encode([
                'success' => true, 
                'message' => 'Login successful',
                'user' => $userData,
                'token' => $token
            ]);
        } else {
            // Return error response
            http_response_code(401);
            echo json_encode(['success' => false, 'message' => 'Invalid PIN']);
        }
    } else {
        // Return error response
        echo json_encode(['success' => false, 'message' => 'Invalid credentials']);
    }
} catch (PDOException $e) {
    // Log error
    error_log("Login error: " . $e->getMessage());
    
    // Return error response
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
