<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once './db_connect.php';

$contentType = isset($_SERVER["CONTENT_TYPE"]) ? trim($_SERVER["CONTENT_TYPE"]) : '';

if ($contentType === "application/json") {
    //Receive the RAW post data.
    $content = trim(file_get_contents("php://input"));

    $decoded = json_decode($content, true);

    //If json_decode failed, the JSON is invalid.
    if(!is_array($decoded)) {
        error_log("Invalid JSON format: " . $content);
        echo json_encode(array('success' => false, 'message' => 'Invalid JSON format'));
        exit;
    }

    error_log("Decoded JSON: " . print_r($decoded, true));

    $email = isset($decoded['email']) ? $decoded['email'] : null;
    $password = isset($decoded['password']) ? $decoded['password'] : null;

    if (!$email || !$password || empty($email) || empty($password)) {
        error_log("Email or password missing in JSON: " . json_encode($decoded));
        echo json_encode(array('success' => false, 'message' => 'Email and password are required (JSON)'));
        exit;
    }
} else {
    if (isset($_POST['email']) && isset($_POST['password'])) {
        $email = $_POST['email'];
        $password = $_POST['password'];
    } else {
        echo json_encode(array('success' => false, 'message' => 'Email and password are required (Form)'));
        exit;
    }
}

$stmt = $pdo->prepare("SELECT `id`, `email`, `password`, `role`, `name` FROM `users` WHERE `email` = ?");
$stmt->execute([$email]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if ($row && password_verify($password, $row['password'])) {
    $token = bin2hex(random_bytes(32));
    
    // Update user's token in the database
    $updateStmt = $pdo->prepare("UPDATE users SET token = ? WHERE id = ?");
    $updateStmt->execute([$token, $row['id']]);

    unset($row['password']); // Remove password from the response
    echo json_encode(array('success' => true, 'user' => $row, 'token' => $token));
} else {
    echo json_encode(array('success' => false, 'message' => 'Invalid credentials'));
}
