<?php
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db_connect.php';

if (isset($_POST['inspectionId']) && isset($_POST['status'])) {
    $inspectionId = $_POST['inspectionId'];
    $status = $_POST['status']; // e.g., 'approved' or 'rejected'
    $regionalManagerId = 1; // Placeholder

    $stmt = $conn->prepare("INSERT INTO approvals (inspection_id, status, regional_manager_id) VALUES (?, ?, ?)");
    $stmt->execute([$inspectionId, $status, $regionalManagerId]);

    if ($stmt->rowCount() > 0) {
        $stmt = $conn->prepare("UPDATE inspections SET status = ? WHERE id = ?");
        $stmt->execute([$status, $inspectionId]);
        echo json_encode(array('success' => true, 'message' => 'Inspection approval updated successfully'));
    } else {
        echo json_encode(array('success' => false, 'message' => 'Error updating inspection approval'));
    }
} else {
    echo json_encode(array('success' => false, 'message' => 'Inspection ID and status are required'));
}