<?php
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db_connect.php';

if (isset($_POST['title']) && isset($_POST['details'])) {
    $title = $_POST['title'];
    $details = $_POST['details'];
    $date = date('Y-m-d');
    $regionalManagerId = 1; // Placeholder

    $stmt = $conn->prepare("INSERT INTO reports (title, date, details, regional_manager_id) VALUES (?, ?, ?, ?)");
    $stmt->execute([$title, $date, $details, $regionalManagerId]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(array('success' => true, 'message' => 'Report generated successfully', 'data' => array('reportId' => $conn->lastInsertId())));
    } else {
        echo json_encode(array('success' => false, 'message' => 'Error generating report'));
    }
} else {
    echo json_encode(array('success' => false, 'message' => 'Title and details are required'));
}