<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'db_connect.php';

$contentType = isset($_SERVER["CONTENT_TYPE"]) ? trim($_SERVER["CONTENT_TYPE"]) : '';

if ($contentType === "application/json") {
    $content = trim(file_get_contents("php://input"));
    $decoded = json_decode($content, true);
    //var_dump($decoded);
    if (!is_array($decoded)) {
        error_log("Invalid JSON format: " . $content);
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Invalid JSON format']);
        exit;
    }

    error_log("Decoded JSON: " . print_r($decoded, true));
    $name = isset($decoded['name']) ? $decoded['name'] : null;
    $email = isset($decoded['email']) ? $decoded['email'] : null;
    $password = isset($decoded['password']) ? password_hash($decoded['password'], PASSWORD_BCRYPT) : null;
    $role = isset($decoded['role']) ? $decoded['role'] : null;

    // Ensure 'washcrew' is properly set as the role for WashCrew members
    if ($role === 'WashCrew' || $role === 'washcrew' || $role === 'wash_crew' || $role === 'wash-crew') {
        $role = 'washcrew';
    }

    error_log("Role after normalization: " . $role);

    $status = isset($decoded['status']) ? $decoded['status'] : 'pending';
    $created_by = isset($decoded['created_by']) ? $decoded['created_by'] : null;

    if (!$name || !$email || !$password || !$role) {
        error_log("Missing fields in JSON: " . json_encode($decoded));
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Name, email, password, and role are required']);
        exit;
    }
} else {
    if (isset($_POST['name']) && isset($_POST['email']) && isset($_POST['password']) && isset($_POST['role'])) {
        $name = $_POST['name'];
        $email = $_POST['email'];
        $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
        $role = $_POST['role'];

        // Ensure 'washcrew' is properly set as the role for WashCrew members
        if ($role === 'WashCrew' || $role === 'washcrew' || $role === 'wash_crew' || $role === 'wash-crew') {
            $role = 'washcrew';
        }

        error_log("Role after normalization (POST): " . $role);

        $status = isset($_POST['status']) ? $_POST['status'] : 'pending';
        $created_by = isset($_POST['created_by']) ? $_POST['created_by'] : null;
    } else {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Name, email, password, and role are required']);
        exit;
    }
}

header('Content-Type: application/json');

try {
    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Invalid email format']);
        exit;
    }

    // Check if email already exists
    $checkStmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $checkStmt->execute([$email]);

    if ($checkStmt->rowCount() > 0) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Email already exists']);
        exit;
    }

    // Log all parameters before insertion
    error_log("Inserting user with parameters: name=$name, email=$email, role=$role, status=$status, created_by=" . ($created_by ? $created_by : 'null'));

    // Prepare SQL statement based on whether created_by is provided
    if ($created_by) {
        $stmt = $pdo->prepare("INSERT INTO `users` (`email`, `password`, `role`, `name`, `status`, `created_by`) VALUES (?, ?, ?, ?, ?, ?)");
        $result = $stmt->execute([$email, $password, $role, $name, $status, $created_by]);
        error_log("SQL execution result with created_by: " . ($result ? 'success' : 'failure'));
    } else {
        $stmt = $pdo->prepare("INSERT INTO `users` (`email`, `password`, `role`, `name`, `status`) VALUES (?, ?, ?, ?, ?)");
        $result = $stmt->execute([$email, $password, $role, $name, $status]);
        error_log("SQL execution result without created_by: " . ($result ? 'success' : 'failure'));
    }

    if ($stmt->rowCount() > 0) {
        http_response_code(201);
        echo json_encode(['success' => true, 'message' => 'Registration successful']);
    } else {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Failed to create user']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>