<?php
// Database connection parameters
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'vehicle_inspection_system';

// Connect to MySQL server
try {
    $pdo = new PDO("mysql:host=$host", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Create database if it doesn't exist
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `$database`");
    echo "Database created or already exists.\n";
    
    // Connect to the database
    $pdo->exec("USE `$database`");
    
    // Create users table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `users` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `user_identifier` varchar(50) DEFAULT NULL UNIQUE,
          `name` varchar(100) NOT NULL,
          `email` varchar(100) NOT NULL UNIQUE,
          `password` varchar(255) NOT NULL,
          `role` enum('owner','regional_manager','yard_manager','dispatch','driver','field_rep','mechanic','wash_crew') NOT NULL,
          `status` enum('active','inactive','suspended') DEFAULT 'active',
          `created_by` int(11) DEFAULT NULL,
          `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
          `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");
    echo "Users table created or already exists.\n";
    
    // Create vehicles table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `vehicles` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `vehicle_identifier` varchar(50) NOT NULL UNIQUE,
          `make` varchar(50) NOT NULL,
          `model` varchar(50) NOT NULL,
          `year` int(4) NOT NULL,
          `license_plate` varchar(20) NOT NULL,
          `status` enum('active','inactive','maintenance','retired') DEFAULT 'active',
          `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
          `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");
    echo "Vehicles table created or already exists.\n";
    
    // Create dispatch_assignments table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `dispatch_assignments` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `assignment_identifier` varchar(50) NOT NULL UNIQUE,
          `driver_id` int(11) NOT NULL,
          `vehicle_id` int(11) NOT NULL,
          `type` enum('Delivery','Pickup','Transfer','Maintenance') NOT NULL,
          `origin_location` varchar(255) NOT NULL,
          `destination_location` varchar(255) NOT NULL,
          `status` enum('Pending','Active','Completed', 'Cancelled') DEFAULT 'Pending',
          `scheduled_time` datetime DEFAULT NULL,
          `start_time` datetime DEFAULT NULL,
          `completion_time` datetime DEFAULT NULL,
          `dispatcher_id` int(11) DEFAULT NULL,
          `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
          `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");
    echo "Dispatch assignments table created or already exists.\n";
    
    // Insert sample users if the table is empty
    $stmt = $pdo->query("SELECT COUNT(*) FROM users");
    $userCount = $stmt->fetchColumn();
    
    if ($userCount == 0) {
        // Insert Owner (ID: 1)
        $pdo->exec("INSERT INTO `users` (`user_identifier`, `name`, `email`, `password`, `role`, `status`) 
                    VALUES ('U0001', 'Admin User', 'admin@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'owner', 'active')");
        
        // Insert Regional Manager (ID: 2)
        $pdo->exec("INSERT INTO `users` (`user_identifier`, `name`, `email`, `password`, `role`, `status`, `created_by`) 
                    VALUES ('U0002', 'Regional Manager', 'regional@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'regional_manager', 'active', 1)");
        
        // Insert Yard Manager (ID: 3)
        $pdo->exec("INSERT INTO `users` (`user_identifier`, `name`, `email`, `password`, `role`, `status`, `created_by`) 
                    VALUES ('U0003', 'Yard Manager', 'yard@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'yard_manager', 'active', 2)");
        
        // Insert Dispatcher (ID: 4)
        $pdo->exec("INSERT INTO `users` (`user_identifier`, `name`, `email`, `password`, `role`, `status`, `created_by`) 
                    VALUES ('U0004', 'Dispatch User', 'dispatch@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'dispatch', 'active', 3)");
        
        // Insert Drivers (IDs: 5-8)
        $pdo->exec("INSERT INTO `users` (`user_identifier`, `name`, `email`, `password`, `role`, `status`, `created_by`) 
                    VALUES ('U0005', 'John Smith', 'john@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'driver', 'active', 4)");
        
        $pdo->exec("INSERT INTO `users` (`user_identifier`, `name`, `email`, `password`, `role`, `status`, `created_by`) 
                    VALUES ('U0006', 'Sarah Johnson', 'sarah@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'driver', 'active', 4)");
        
        $pdo->exec("INSERT INTO `users` (`user_identifier`, `name`, `email`, `password`, `role`, `status`, `created_by`) 
                    VALUES ('U0007', 'Michael Brown', 'michael@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'driver', 'active', 4)");
        
        $pdo->exec("INSERT INTO `users` (`user_identifier`, `name`, `email`, `password`, `role`, `status`, `created_by`) 
                    VALUES ('U0008', 'Emily Davis', 'emily@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'driver', 'active', 4)");
        
        echo "Sample users inserted.\n";
    } else {
        echo "Users table already has data, skipping sample user insertion.\n";
    }
    
    // Insert sample vehicles if the table is empty
    $stmt = $pdo->query("SELECT COUNT(*) FROM vehicles");
    $vehicleCount = $stmt->fetchColumn();
    
    if ($vehicleCount == 0) {
        $pdo->exec("INSERT INTO `vehicles` (`vehicle_identifier`, `make`, `model`, `year`, `license_plate`, `status`) 
                    VALUES ('TRK-2023-A', 'Ford', 'F-150', 2023, 'ABC-1234', 'active')");
        
        $pdo->exec("INSERT INTO `vehicles` (`vehicle_identifier`, `make`, `model`, `year`, `license_plate`, `status`) 
                    VALUES ('TRK-2023-B', 'Chevrolet', 'Silverado', 2023, 'DEF-5678', 'active')");
        
        $pdo->exec("INSERT INTO `vehicles` (`vehicle_identifier`, `make`, `model`, `year`, `license_plate`, `status`) 
                    VALUES ('TRK-2023-C', 'Ram', '1500', 2023, 'GHI-9012', 'active')");
        
        $pdo->exec("INSERT INTO `vehicles` (`vehicle_identifier`, `make`, `model`, `year`, `license_plate`, `status`) 
                    VALUES ('TRK-2023-D', 'Toyota', 'Tundra', 2023, 'JKL-3456', 'active')");
        
        echo "Sample vehicles inserted.\n";
    } else {
        echo "Vehicles table already has data, skipping sample vehicle insertion.\n";
    }
    
    // Insert sample assignments if the table is empty
    $stmt = $pdo->query("SELECT COUNT(*) FROM dispatch_assignments");
    $assignmentCount = $stmt->fetchColumn();
    
    if ($assignmentCount == 0) {
        $pdo->exec("INSERT INTO `dispatch_assignments` (`assignment_identifier`, `driver_id`, `vehicle_id`, `type`, `origin_location`, `destination_location`, `status`, `scheduled_time`, `start_time`, `completion_time`, `dispatcher_id`)
                    VALUES ('A001', 5, 1, 'Delivery', 'Central Warehouse', 'Customer Site Alpha', 'Pending', '2023-10-25 09:00:00', NULL, NULL, 4)");
        
        $pdo->exec("INSERT INTO `dispatch_assignments` (`assignment_identifier`, `driver_id`, `vehicle_id`, `type`, `origin_location`, `destination_location`, `status`, `scheduled_time`, `start_time`, `completion_time`, `dispatcher_id`)
                    VALUES ('A002', 6, 2, 'Pickup', 'Supplier Beta', 'Central Warehouse', 'Active', '2023-10-24 14:00:00', '2023-10-24 14:15:00', NULL, 4)");
        
        $pdo->exec("INSERT INTO `dispatch_assignments` (`assignment_identifier`, `driver_id`, `vehicle_id`, `type`, `origin_location`, `destination_location`, `status`, `scheduled_time`, `start_time`, `completion_time`, `dispatcher_id`)
                    VALUES ('A003', 7, 3, 'Transfer', 'North Depot', 'South Depot', 'Active', '2023-10-24 10:30:00', '2023-10-24 10:45:00', NULL, 4)");
        
        $pdo->exec("INSERT INTO `dispatch_assignments` (`assignment_identifier`, `driver_id`, `vehicle_id`, `type`, `origin_location`, `destination_location`, `status`, `scheduled_time`, `start_time`, `completion_time`, `dispatcher_id`)
                    VALUES ('A004', 8, 4, 'Maintenance', 'East Facility', 'Service Center', 'Completed', '2023-10-23 08:00:00', '2023-10-23 08:10:00', '2023-10-23 11:45:00', 4)");
        
        $pdo->exec("INSERT INTO `dispatch_assignments` (`assignment_identifier`, `driver_id`, `vehicle_id`, `type`, `origin_location`, `destination_location`, `status`, `scheduled_time`, `start_time`, `completion_time`, `dispatcher_id`)
                    VALUES ('A005', 5, 1, 'Delivery', 'Central Warehouse', 'Customer Site Delta', 'Pending', '2023-10-25 13:30:00', NULL, NULL, 4)");
        
        $pdo->exec("INSERT INTO `dispatch_assignments` (`assignment_identifier`, `driver_id`, `vehicle_id`, `type`, `origin_location`, `destination_location`, `status`, `scheduled_time`, `start_time`, `completion_time`, `dispatcher_id`)
                    VALUES ('A006', 6, 2, 'Pickup', 'Customer Site Gamma', 'Central Warehouse', 'Completed', '2023-10-22 15:00:00', '2023-10-22 15:05:00', '2023-10-22 16:30:00', 4)");
        
        echo "Sample assignments inserted.\n";
    } else {
        echo "Assignments table already has data, skipping sample assignment insertion.\n";
    }
    
    echo "Database setup completed successfully!";
    
} catch (PDOException $e) {
    die("Database setup failed: " . $e->getMessage());
}
?>

