<?php
require_once 'db_connect.php';

// Function to run SQL file
function runSQLFile($pdo, $file) {
    echo "Running SQL file: $file\n";
    
    try {
        $sql = file_get_contents($file);
        $pdo->exec($sql);
        echo "Successfully executed $file\n";
    } catch (PDOException $e) {
        echo "Error executing $file: " . $e->getMessage() . "\n";
    }
}

// Get all SQL files in the sql directory
$sqlFiles = glob(__DIR__ . '/sql/*.sql');

// Run each SQL file
foreach ($sqlFiles as $file) {
    runSQLFile($pdo, $file);
}

echo "Setup complete!\n";
?>
