<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db_connect.php';

// Set content type to HTML for better readability in browser
header('Content-Type: text/html');

echo "<h1>Simulate Login</h1>";

// Get user ID from query parameter
$userId = isset($_GET['user_id']) ? intval($_GET['user_id']) : null;

try {
    if ($userId) {
        // Get user details
        $stmt = $pdo->prepare("SELECT id, name, email, role FROM users WHERE id = ?");
        $stmt->execute([$userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            echo "<h2>User Found</h2>";
            echo "<p>ID: " . htmlspecialchars($user['id']) . "</p>";
            echo "<p>Name: " . htmlspecialchars($user['name']) . "</p>";
            echo "<p>Email: " . htmlspecialchars($user['email']) . "</p>";
            echo "<p>Role: " . htmlspecialchars($user['role']) . "</p>";
            
            // Generate session storage code
            $sessionCode = "sessionStorage.setItem('user', '" . json_encode($user) . "');";
            
            echo "<h2>Session Storage Code</h2>";
            echo "<p>Copy and paste this code into your browser's console to simulate login:</p>";
            echo "<textarea rows='3' cols='80' onclick='this.select()'>" . htmlspecialchars($sessionCode) . "</textarea>";
            
            echo "<h2>Or click this button:</h2>";
            echo "<button onclick=\"" . htmlspecialchars($sessionCode) . " alert('Login simulated for " . htmlspecialchars($user['name']) . "');\">Simulate Login</button>";
            
            echo "<p><a href='javascript:void(0)' onclick=\"sessionStorage.removeItem('user'); alert('Logged out');\">Log Out</a></p>";
        } else {
            echo "<h2>User Not Found</h2>";
            echo "<p>No user found with ID: $userId</p>";
        }
    }
    
    // Show all users
    $allStmt = $pdo->prepare("
        SELECT id, name, email, role 
        FROM users 
        ORDER BY role, id
    ");
    $allStmt->execute();
    $allUsers = $allStmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>All Users</h2>";
    echo "<p>Click on a user ID to simulate login:</p>";
    
    if (count($allUsers) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Action</th></tr>";
        
        foreach ($allUsers as $user) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['id']) . "</td>";
            echo "<td>" . htmlspecialchars($user['name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>" . htmlspecialchars($user['role']) . "</td>";
            echo "<td><a href='?user_id=" . $user['id'] . "'>Simulate Login</a></td>";
            echo "</tr>";
        }
        
        echo "</table>";
    } else {
        echo "<p>No users found in the database.</p>";
    }
    
} catch (PDOException $e) {
    echo "<h2>Error</h2>";
    echo "<p>Database error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
