-- Create tasks table if it doesn't exist
CREATE TABLE IF NOT EXISTS `tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text,
  `priority` enum('High', 'Medium', 'Low') NOT NULL DEFAULT 'Medium',
  `due_date` date DEFAULT NULL,
  `assignee_id` int(11) DEFAULT NULL,
  `status` enum('pending', 'in_progress', 'completed', 'cancelled') NOT NULL DEFAULT 'pending',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `assignee_id` (`assignee_id`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `tasks_ibfk_1` FOREIGN KEY (`assignee_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert sample tasks if the table is empty
INSERT INTO `tasks` (`title`, `description`, `priority`, `due_date`, `assignee_id`, `status`, `created_by`)
SELECT 'Deliver equipment to Site A', 'Deliver the new excavator to construction site A by end of day', 'High', DATE_ADD(CURDATE(), INTERVAL 1 DAY), 
       (SELECT id FROM users WHERE role = 'driver' LIMIT 1), 
       'pending', 
       (SELECT id FROM users WHERE role = 'dispatch' LIMIT 1)
FROM dual
WHERE NOT EXISTS (SELECT 1 FROM tasks LIMIT 1);

INSERT INTO `tasks` (`title`, `description`, `priority`, `due_date`, `assignee_id`, `status`, `created_by`)
SELECT 'Pick up materials from supplier', 'Collect ordered materials from ABC Suppliers', 'Medium', DATE_ADD(CURDATE(), INTERVAL 2 DAY), 
       (SELECT id FROM users WHERE role = 'driver' LIMIT 1 OFFSET 1), 
       'pending', 
       (SELECT id FROM users WHERE role = 'dispatch' LIMIT 1)
FROM dual
WHERE NOT EXISTS (SELECT 1 FROM tasks LIMIT 1);

INSERT INTO `tasks` (`title`, `description`, `priority`, `due_date`, `status`, `created_by`)
SELECT 'Schedule vehicle maintenance', 'Arrange maintenance for vehicles #103, #105, and #108', 'Low', DATE_ADD(CURDATE(), INTERVAL 5 DAY), 
       'pending', 
       (SELECT id FROM users WHERE role = 'dispatch' LIMIT 1)
FROM dual
WHERE NOT EXISTS (SELECT 1 FROM tasks LIMIT 1);
