<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
// if (!$user_id || $user_role !== 'dispatch') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'GET') {
    // Fetch active route details
    // This joins the dynamic 'active_routes' data with static assignment details
    $sql = "SELECT 
                ar.id AS active_route_db_id, 
                ar.route_identifier, 
                ar.status_text, 
                ar.current_location_text, 
                ar.eta_text,
                da.assignment_identifier,
                da.destination_location,
                u.name AS driver_name,
                v.vehicle_identifier
            FROM active_routes ar
            JOIN dispatch_assignments da ON ar.assignment_id = da.id
            JOIN users u ON da.driver_id = u.id
            JOIN vehicles v ON da.vehicle_id = v.id
            WHERE da.status = 'Active' -- Ensure we only fetch routes for currently active assignments
            ORDER BY ar.last_updated DESC"; // Or order as needed
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    // No parameters to bind in this example

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $routes = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $routes[] = $row;
        }
        echo json_encode($routes);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>