<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 2; // Hardcoding Driver Alice Brown (ID 2) for now, replace with actual auth
$user_role = 'driver'; 
// if (!$user_id || $user_role !== 'driver') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'GET') {
    // Ensure the user is a driver and has an ID
    if (!$user_id || $user_role !== 'driver') {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }

    // Fetch messages sent to or by this driver, involving dispatch
    // Find the dispatcher's ID (assuming only one dispatcher for simplicity, or a specific one)
    $dispatcher_id = null;
    $stmt_dispatch = $conn->prepare("SELECT id FROM users WHERE role = 'dispatch' LIMIT 1"); // Find one dispatcher
    if ($stmt_dispatch) {
        if ($stmt_dispatch->execute()) {
            $result_dispatch = $stmt_dispatch->get_result();
            if ($row_dispatch = $result_dispatch->fetch_assoc()) {
                $dispatcher_id = $row_dispatch['id'];
            }
        }
        $stmt_dispatch->close();
    }
    
    if (!$dispatcher_id) {
         // If no dispatcher found, maybe return empty or error?
         echo json_encode([]); 
         error_log("No dispatcher user found in the database."); // Log this issue
         exit();
    }


    $sql = "SELECT 
                c.id, 
                c.message_text, 
                c.sent_at, 
                sender.role AS sender_role
                -- No need to fetch names here as the driver view only shows 'Dispatch' or implies 'Me'
            FROM communications c
            JOIN users sender ON c.sender_user_id = sender.id
            WHERE (c.sender_user_id = ? AND c.recipient_user_id = ?) -- Driver sent to Dispatch
               OR (c.sender_user_id = ? AND c.recipient_user_id = ?) -- Dispatch sent to Driver
            ORDER BY c.sent_at ASC"; // Order chronologically

    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    $stmt->bind_param("iiii", $user_id, $dispatcher_id, $dispatcher_id, $user_id);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $messages = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            // Format timestamp
             if ($row['sent_at']) {
                 $dt = new DateTime($row['sent_at']);
                 $row['sent_at_formatted'] = $dt->format('Y-m-d H:i:s'); 
             }
            $messages[] = $row;
        }
        echo json_encode($messages);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} elseif ($method == 'POST') {
    // Save a new message sent by the driver TO dispatch
     if ($user_role !== 'driver') {
        http_response_code(403); 
        echo json_encode(['error' => 'Only drivers can send messages via this endpoint.']);
        exit();
    }
    
    $data = json_decode(file_get_contents('php://input'), true);
    $message_text = $data['message_text'] ?? null;

    if (!$message_text) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing message text.']);
        exit();
    }

    // Find the dispatcher's ID (assuming only one dispatcher for simplicity)
    $dispatcher_id = null;
    $stmt_dispatch = $conn->prepare("SELECT id FROM users WHERE role = 'dispatch' LIMIT 1");
     if ($stmt_dispatch) {
        if ($stmt_dispatch->execute()) {
            $result_dispatch = $stmt_dispatch->get_result();
            if ($row_dispatch = $result_dispatch->fetch_assoc()) {
                $dispatcher_id = $row_dispatch['id'];
            }
        }
        $stmt_dispatch->close();
    }

    if (!$dispatcher_id) {
         http_response_code(500); // Internal error - should have a dispatcher
         echo json_encode(['error' => 'Dispatcher user not found. Cannot send message.']);
         exit();
    }

    // Insert the message
    $sql = "INSERT INTO communications (sender_user_id, recipient_user_id, sender_role, message_text, sent_at) 
            VALUES (?, ?, ?, ?, NOW())";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare insert statement: ' . $conn->error]);
        exit();
    }

    $sender_role_db = 'driver'; // Explicitly set sender role
    $stmt->bind_param("iiss", $user_id, $dispatcher_id, $sender_role_db, $message_text);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Message sent.', 'message_id' => $stmt->insert_id]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to send message: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>