<?php
require_once '../db_connect.php'; // Include connection just in case

header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
// $user_name = $_SESSION['user_name'] ?? null; 
// $user_email = $_SESSION['user_email'] ?? null; 
$user_id = 2; // Hardcoding Driver Alice Brown (ID 2) for now
$user_role = 'driver'; 
$user_name = 'Alice Brown'; // Hardcoding
$user_email = 'driver5@example.com'; // Hardcoding
// if (!$user_id || $user_role !== 'driver') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // Basic validation
    $subject = $data['subject'] ?? null;
    $assignmentId = $data['assignmentId'] ?? null; // Optional Assignment ID
    $description = $data['description'] ?? null;
    $role = $data['role'] ?? 'driver'; 

    if ($subject && $description) { 
        
        // --- Placeholder for actual support request handling ---
        // 1. Store in a database table (e.g., `support_tickets`)
        /*
        $sql = "INSERT INTO support_tickets (subject, name, email, description, role, related_assignment_id, status, created_at, user_id) 
                VALUES (?, ?, ?, ?, ?, ?, 'new', NOW(), ?)";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("ssssssi", $subject, $user_name, $user_email, $description, $role, $assignmentId, $user_id); 
            $stmt->execute();
            $stmt->close();
        } else {
             error_log("Failed to prepare statement for support ticket: " . $conn->error);
        }
        */

        // 2. Send an email notification (e.g., to Dispatch or Safety)
        /*
        $to = "dispatch.support@visapp.com"; // Or safety@visapp.com
        $email_subject = "New Driver Support Report ($role): " . $subject;
        $headers = "From: no-reply@visapp.com\r\n";
        $headers .= "Reply-To: " . $user_email . "\r\n"; 
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        
        $email_body = "New driver support report received:\n\n";
        $email_body .= "From Driver: " . $user_name . " (" . $user_email . ")\n";
        if ($assignmentId) {
             $email_body .= "Related Assignment ID: " . $assignmentId . "\n";
        }
        $email_body .= "Subject: " . $subject . "\n\n";
        $email_body .= "Description:\n" . $description;

        // Use mail() function or a library
        // mail($to, $email_subject, $email_body, $headers); 
        */
        
        // For now, just return success
        echo json_encode(['success' => true, 'message' => 'Report received.']);
        
    } else {
        http_response_code(400); // Bad Request
        echo json_encode(['error' => 'Invalid or missing data. Please provide subject and description.']);
    }

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close(); // Close connection if it was used
?>