<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 2; // Hardcoding Driver Alice Brown (ID 2) for now, replace with actual auth
$user_role = 'driver'; 
// if (!$user_id || $user_role !== 'driver') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'POST') {
     // Ensure the user is a driver and has an ID
    if (!$user_id || $user_role !== 'driver') {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }

    $data = json_decode(file_get_contents('php://input'), true);

    // Basic validation
    $vehicle_id = $data['vehicle_id'] ?? null;
    $check_type = $data['check_type'] ?? null;
    $checklist_data_json = $data['checklist_data'] ?? null; // Expecting JSON string
    $notes = $data['notes'] ?? null;
    $issues_found = isset($data['issues_found']) ? (bool)$data['issues_found'] : false; 

    // Validate input
    if (!$vehicle_id || !$check_type || !$checklist_data_json || !in_array($check_type, ['pre-trip', 'post-trip'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid or missing required fields (vehicle_id, check_type, checklist_data).']);
        exit();
    }
    
    // Further validation: Check if checklist_data is valid JSON
    json_decode($checklist_data_json);
    if (json_last_error() !== JSON_ERROR_NONE) {
         http_response_code(400);
         echo json_encode(['error' => 'Invalid checklist_data format. Expected JSON string.']);
         exit();
    }

    // Insert the vehicle check record
    $sql = "INSERT INTO vehicle_checks (driver_id, vehicle_id, check_type, checklist_data, notes, issues_found, submitted_at) 
            VALUES (?, ?, ?, ?, ?, ?, NOW())";
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    // Convert boolean issues_found to integer for binding
    $issues_found_int = $issues_found ? 1 : 0;
    $stmt->bind_param("iisssi", $user_id, $vehicle_id, $check_type, $checklist_data_json, $notes, $issues_found_int);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Vehicle check submitted successfully.', 'check_id' => $stmt->insert_id]);
        
        // Optional: Trigger notifications or update vehicle status if issues were found
        // if ($issues_found) {
        //    // e.g., Update vehicles table status, insert into vehicle_issues table, send alert
        // }

    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to submit vehicle check: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed. Only POST is accepted.']);
}

$conn->close();
?>