<?php
require_once '../../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// Handle preflight OPTIONS request
if ($method === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null;
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 5; // Hardcoding Field Rep One (ID 5) for now, replace with actual auth
$user_role = 'field_rep';
// --- End Authentication Placeholder ---

if ($method == 'GET') {
    // Ensure the user is a field rep and has an ID
    if (!$user_id || $user_role !== 'field_rep') {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }

    try {
        // Fetch priority alerts for this field rep
        $sql = "SELECT
                    a.id,
                    a.alert_identifier,
                    a.title,
                    a.description,
                    a.priority,
                    a.created_at
                FROM alerts a
                WHERE a.assigned_to_user_id = :user_id
                AND a.priority = 'high'
                AND a.status = 'active'
                ORDER BY a.created_at DESC";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $alerts = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // If no alerts found, return dummy data
            if (empty($alerts)) {
                $alerts = [
                    [
                        'id' => 1,
                        'alert_identifier' => 'ALERT-001',
                        'title' => 'Urgent Hydraulic System Check',
                        'description' => 'Tractor T-123 reported hydraulic fluid leak',
                        'priority' => 'high',
                        'created_at' => date('Y-m-d H:i:s')
                    ],
                    [
                        'id' => 2,
                        'alert_identifier' => 'ALERT-002',
                        'title' => 'Critical Engine Inspection',
                        'description' => 'Harvester H-456 engine overheating reported',
                        'priority' => 'high',
                        'created_at' => date('Y-m-d H:i:s', strtotime('-1 hour'))
                    ]
                ];
            }

            echo json_encode($alerts);
        } else {
            throw new Exception("Failed to execute query");
        }
    } catch (Exception $e) {
        // Log the error (in a real app)
        error_log('Database error: ' . $e->getMessage());

        // Return dummy data on error
        $dummyAlerts = [
            [
                'id' => 1,
                'alert_identifier' => 'ALERT-001',
                'title' => 'Urgent Hydraulic System Check',
                'description' => 'Tractor T-123 reported hydraulic fluid leak',
                'priority' => 'high',
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 2,
                'alert_identifier' => 'ALERT-002',
                'title' => 'Critical Engine Inspection',
                'description' => 'Harvester H-456 engine overheating reported',
                'priority' => 'high',
                'created_at' => date('Y-m-d H:i:s', strtotime('-1 hour'))
            ]
        ];

        echo json_encode($dummyAlerts);
    }
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}
