<?php
require_once 'api.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $userId = validateToken();
        
        $stmt = $pdo->prepare("
            SELECT 
                sr.id,
                sr.service_date,
                sr.service_type,
                sr.description,
                sr.status,
                sr.completion_date,
                v.identifier as vehicle_identifier,
                v.make,
                v.model,
                v.year,
                y.name as yard_name
            FROM service_records sr
            LEFT JOIN vehicles v ON sr.vehicle_id = v.id
            LEFT JOIN yards y ON v.yard_id = y.id
            WHERE sr.technician_id = ?
            ORDER BY sr.service_date DESC
        ");
        
        $stmt->execute([$userId]);
        $records = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'data' => $records
        ]);
        
    } catch (Exception $e) {
        handleError($e->getMessage());
    }
}

else if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $userId = validateToken();
        $data = json_decode(file_get_contents('php://input'), true);
        
        // Validate required fields
        if (!isset($data['vehicle_id']) || !isset($data['service_type']) || !isset($data['description'])) {
            handleError('Missing required fields', 400);
        }
        
        $stmt = $pdo->prepare("
            INSERT INTO service_records 
            (technician_id, vehicle_id, service_type, description, service_date, status)
            VALUES (?, ?, ?, ?, NOW(), 'Pending')
        ");
        
        $stmt->execute([
            $userId,
            $data['vehicle_id'],
            $data['service_type'],
            $data['description']
        ]);
        
        echo json_encode([
            'success' => true,
            'message' => 'Service record created successfully',
            'id' => $pdo->lastInsertId()
        ]);
        
    } catch (Exception $e) {
        handleError($e->getMessage());
    }
}

else if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    try {
        $userId = validateToken();
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (!isset($data['id']) || !isset($data['status'])) {
            handleError('Missing required fields', 400);
        }
        
        $stmt = $pdo->prepare("
            UPDATE service_records 
            SET status = ?,
                completion_date = CASE WHEN ? = 'Completed' THEN NOW() ELSE completion_date END
            WHERE id = ? AND technician_id = ?
        ");
        
        $stmt->execute([
            $data['status'],
            $data['status'],
            $data['id'],
            $userId
        ]);
        
        echo json_encode([
            'success' => true,
            'message' => 'Service record updated successfully'
        ]);
        
    } catch (Exception $e) {
        handleError($e->getMessage());
    }
}

else {
    handleError('Method not allowed', 405);
}
?>
