<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");
require_once '../../db_connect.php'; // Adjust path as needed
// --- Authentication Placeholder ---
// In a real app, you'd verify the user's session/token and ensure they have owner privileges
// --- End Authentication Placeholder ---

// No specific input needed for this example (fetching all defects)
// In a real app, you might want to add filtering options (by severity, status, etc.)

$sql = "SELECT 
            id, 
            description, 
            severity, 
            status, 
            asset_id,
            inspection_id,
            created_at,
            updated_at
        FROM defects
        ORDER BY created_at DESC";

$stmt = $pdo->prepare($sql);
if ($stmt === false) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to prepare statement: ' . $pdo->errorInfo()[2]]);
    exit();
}

if ($stmt->execute()) {
    $defects = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Format date if needed
        if ($row['created_at']) {
            $date = new DateTime($row['created_at']);
            $row['created_at'] = $date->format('Y-m-d');
        }
        $defects[] = $row;
    }
    echo json_encode($defects);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to execute query: ' . $stmt->errorInfo()[2]]);
}

$stmt = null;
$pdo = null;
?>
