<?php
require_once '../../db_connect.php'; // Corrected path to db_connect.php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];

// Assuming yard_id might be needed later, e.g., from session or request
// $yard_id = $_SESSION['yard_id'] ?? null; // Example: Get yard_id from session
$yard_id = 1; // Hardcoding for now based on dummy data structure, adjust as needed

if ($method == 'GET') {
    try {
        // Fetch inspections, potentially filtered by yard_id if available
        // Joining with vehicles to get the identifier
        $sql = "SELECT i.id, v.vehicle_identifier, i.inspection_date, i.status
                FROM inspections i
                JOIN vehicles v ON i.vehicle_id = v.id";

        // Example filtering by yard_id if needed in a real scenario
        // if ($yard_id) {
        //     $sql .= " WHERE i.yard_id = ?";
        //     $params = [$yard_id];
        // } else {
        //     $params = [];
        // }
        $params = [];

        // Prepare and execute the statement using PDO
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);

        // Fetch all results
        $inspections = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Return the results as JSON
        echo json_encode($inspections);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }

} elseif ($method == 'POST') {
    try {
        // Handle status updates (Approve/Flag) - Placeholder
        $data = json_decode(file_get_contents('php://input'), true);
        $action = $data['action'] ?? null;
        $inspection_id = $data['id'] ?? null;

        if ($inspection_id && ($action == 'approve' || $action == 'flag')) {
            $new_status = ($action == 'approve') ? 'approved' : 'flagged';

            $sql = "UPDATE inspections SET status = ? WHERE id = ?";
            // Add yard_id check if necessary: "UPDATE inspections SET status = ? WHERE id = ? AND yard_id = ?"

            // Prepare and execute the statement using PDO
            $stmt = $pdo->prepare($sql);
            $result = $stmt->execute([$new_status, $inspection_id]);

            if ($result) {
                $rowCount = $stmt->rowCount();
                if ($rowCount > 0) {
                    echo json_encode(['success' => true, 'message' => "Inspection $inspection_id status updated to $new_status."]);
                } else {
                    // Check if the inspection exists and belongs to the yard if filtering
                    http_response_code(404); // Or 403 Forbidden
                    echo json_encode(['error' => "Inspection not found or no change needed."]);
                }
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to update inspection status']);
            }
        } else {
            http_response_code(400); // Bad Request
            echo json_encode(['error' => 'Invalid action or missing inspection ID.']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}
?>