<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// Assuming yard_id might be needed later, e.g., from session or request
// $yard_id = $_SESSION['yard_id'] ?? null; // Example: Get yard_id from session
// For now, fetching all tasks as the dummy data wasn't explicitly yard-specific

if ($method == 'GET') {
    // Fetch maintenance tasks, joining with vehicles
    $sql = "SELECT 
                mt.id AS maintenance_task_db_id, 
                mt.task_identifier, 
                mt.description, 
                mt.status, 
                mt.priority, 
                mt.scheduled_date, 
                mt.start_date, 
                mt.completion_date,
                v.vehicle_identifier
            FROM maintenance_tasks mt
            JOIN vehicles v ON mt.vehicle_id = v.id";
            
    // Example filtering by yard_id if maintenance tasks were linked to yards
    // $sql .= " JOIN vehicles v ON mt.vehicle_id = v.id WHERE v.yard_id = ?";
    
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    // If filtering by yard_id: $stmt->bind_param("i", $yard_id);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $tasks = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
             // Format dates if not null
            if ($row['scheduled_date']) {
                 $date = new DateTime($row['scheduled_date']);
                 $row['scheduled_date'] = $date->format('Y-m-d');
            }
             if ($row['start_date']) {
                 $date = new DateTime($row['start_date']);
                 // Add context for display if needed
                 $row['start_date'] = 'Started ' . $date->format('Y-m-d'); 
            }
             if ($row['completion_date']) {
                 $date = new DateTime($row['completion_date']);
                 $row['completion_date'] = $date->format('Y-m-d');
            }
            $tasks[] = $row;
        }
        echo json_encode($tasks);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} elseif ($method == 'POST') {
    // Placeholder for creating/updating maintenance tasks
    // $data = json_decode(file_get_contents('php://input'), true);
    // ... logic to insert or update ...
    http_response_code(501); // Not Implemented
    echo json_encode(['error' => 'POST method not implemented yet.']);

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>