<?php
// Simple version of maintenance.php with minimal dependencies and error handling

// Database connection parameters
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'vehicle_inspection_system';

// Set headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Create a simple response for testing
$testResponse = [
    [
        'id' => 1,
        'task_identifier' => 'TASK-1001',
        'description' => 'Oil Change & Filter Replacement',
        'status' => 'Scheduled',
        'priority' => 'Medium',
        'scheduled_date' => '2023-12-15',
        'start_date' => null,
        'completion_date' => null,
        'vehicle_identifier' => 'TRK-2001'
    ],
    [
        'id' => 2,
        'task_identifier' => 'TASK-1002',
        'description' => 'Engine Repair',
        'status' => 'In Progress',
        'priority' => 'High',
        'scheduled_date' => '2023-12-10',
        'start_date' => '2023-12-12',
        'completion_date' => null,
        'vehicle_identifier' => 'TRK-2002'
    ],
    [
        'id' => 3,
        'task_identifier' => 'TASK-1003',
        'description' => 'Tire Rotation',
        'status' => 'Completed',
        'priority' => 'Low',
        'scheduled_date' => '2023-12-05',
        'start_date' => '2023-12-05',
        'completion_date' => '2023-12-06',
        'vehicle_identifier' => 'TRK-2003'
    ],
    [
        'id' => 4,
        'task_identifier' => 'TASK-1004',
        'description' => 'Brake Inspection',
        'status' => 'Scheduled',
        'priority' => 'Medium',
        'scheduled_date' => '2023-12-20',
        'start_date' => null,
        'completion_date' => null,
        'vehicle_identifier' => 'TRK-2004'
    ]
];

// Return the test response
echo json_encode($testResponse);
?>
