<?php
require_once '../db_connect.php'; // Include connection just in case, though not used here

header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];

if ($method == 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // Basic validation
    $subject = $data['subject'] ?? null;
    $name = $data['name'] ?? null;
    $email = $data['email'] ?? null;
    $description = $data['description'] ?? null;
    $role = $data['role'] ?? null; // Identify sender role

    if ($subject && $name && $email && $description && filter_var($email, FILTER_VALIDATE_EMAIL)) {
        
        // --- Placeholder for actual support request handling ---
        // 1. Store in a database table (e.g., `support_tickets`)
        /*
        $sql = "INSERT INTO support_tickets (subject, name, email, description, role, status, created_at) 
                VALUES (?, ?, ?, ?, ?, 'new', NOW())";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("sssss", $subject, $name, $email, $description, $role);
            $stmt->execute();
            $stmt->close();
        } else {
             // Log error, but maybe don't fail the request entirely?
             error_log("Failed to prepare statement for support ticket: " . $conn->error);
        }
        */

        // 2. Send an email notification
        /*
        $to = "support@visapp.com"; // Your support email
        $email_subject = "New Support Request ($role): " . $subject;
        $headers = "From: no-reply@visapp.com\r\n";
        $headers .= "Reply-To: " . $email . "\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        
        $email_body = "New support request received:\n\n";
        $email_body .= "From: " . $name . " (" . $email . ")\n";
        $email_body .= "Role: " . $role . "\n";
        $email_body .= "Subject: " . $subject . "\n\n";
        $email_body .= "Description:\n" . $description;

        // Use mail() function (ensure server is configured) or a library like PHPMailer
        // mail($to, $email_subject, $email_body, $headers); 
        */
        
        // For now, just return success
        echo json_encode(['success' => true, 'message' => 'Request received.']);
        
    } else {
        http_response_code(400); // Bad Request
        echo json_encode(['error' => 'Invalid or missing data. Please fill all fields correctly.']);
    }

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close(); // Close connection if it was used
?>