<?php
// Simple version of vehicles.php with minimal dependencies and error handling

// Database connection parameters
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'vehicle_inspection_system';

// Set headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Create a simple response for testing
$testResponse = [
    [
        'id' => 1,
        'vehicle_identifier' => 'TRK-2001',
        'vehicle_type_name' => 'Tractor',
        'status' => 'Operational',
        'location_text' => 'Main Yard',
        'yard_name' => 'North Region',
        'assigned_driver_name' => 'John Doe',
        'maintenance_due_date' => '2023-12-31'
    ],
    [
        'id' => 2,
        'vehicle_identifier' => 'TRK-2002',
        'vehicle_type_name' => 'Trailer',
        'status' => 'Maintenance',
        'location_text' => 'Workshop',
        'yard_name' => 'North Region',
        'assigned_driver_name' => null,
        'maintenance_due_date' => '2023-12-15'
    ],
    [
        'id' => 3,
        'vehicle_identifier' => 'TRK-2003',
        'vehicle_type_name' => 'Tractor',
        'status' => 'On Route',
        'location_text' => 'Highway 101',
        'yard_name' => 'North Region',
        'assigned_driver_name' => 'Jane Smith',
        'maintenance_due_date' => '2024-01-15'
    ],
    [
        'id' => 4,
        'vehicle_identifier' => 'TRK-2004',
        'vehicle_type_name' => 'Trailer',
        'status' => 'Out of Service',
        'location_text' => 'Repair Shop',
        'yard_name' => 'North Region',
        'assigned_driver_name' => null,
        'maintenance_due_date' => null
    ],
    [
        'id' => 5,
        'vehicle_identifier' => 'TRK-2005',
        'vehicle_type_name' => 'Tractor',
        'status' => 'Ready',
        'location_text' => 'Main Yard',
        'yard_name' => 'North Region',
        'assigned_driver_name' => 'Mike Johnson',
        'maintenance_due_date' => '2024-02-01'
    ],
    [
        'id' => 6,
        'vehicle_identifier' => 'TRK-2006',
        'vehicle_type_name' => 'Trailer',
        'status' => 'Cleaning',
        'location_text' => 'Wash Bay',
        'yard_name' => 'North Region',
        'assigned_driver_name' => null,
        'maintenance_due_date' => '2024-01-10'
    ]
];

// Return the test response
echo json_encode($testResponse);
?>
