<?php
// Set CORS headers
header("Access-Control-Allow-Origin: http://localhost:3000");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Return a simple JSON response
echo json_encode([
    'success' => true,
    'message' => 'CORS is working correctly',
    'server_info' => [
        'php_version' => phpversion(),
        'server_software' => $_SERVER['SERVER_SOFTWARE'],
        'request_method' => $_SERVER['REQUEST_METHOD'],
        'request_time' => date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']),
        'remote_addr' => $_SERVER['REMOTE_ADDR'],
        'http_origin' => $_SERVER['HTTP_ORIGIN'] ?? 'Not set'
    ]
]);
?>