<?php
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'vehicle_inspection_system';

header("Access-Control-Allow-Origin: *");
header("Content-Type: text/html");

echo "<h1>Database Connection Test</h1>";

try {
    // Create PDO connection
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<p style='color:green'>Database connection successful!</p>";
    
    // Test if vehicles table exists and has data
    $stmt = $pdo->query("SHOW TABLES LIKE 'vehicles'");
    if ($stmt->rowCount() > 0) {
        echo "<p>Vehicles table exists.</p>";
        
        // Count vehicles
        $stmt = $pdo->query("SELECT COUNT(*) FROM vehicles");
        $count = $stmt->fetchColumn();
        echo "<p>Number of vehicles in database: $count</p>";
        
        if ($count > 0) {
            // Get first vehicle
            $stmt = $pdo->query("SELECT * FROM vehicles LIMIT 1");
            $vehicle = $stmt->fetch(PDO::FETCH_ASSOC);
            
            echo "<h2>Sample Vehicle Data:</h2>";
            echo "<pre>";
            print_r($vehicle);
            echo "</pre>";
        } else {
            echo "<p style='color:red'>No vehicles found in the database.</p>";
        }
    } else {
        echo "<p style='color:red'>Vehicles table does not exist!</p>";
    }
    
    // Test if vehicle_types table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'vehicle_types'");
    if ($stmt->rowCount() > 0) {
        echo "<p>Vehicle_types table exists.</p>";
    } else {
        echo "<p style='color:red'>Vehicle_types table does not exist!</p>";
    }
    
    // Test if yards table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'yards'");
    if ($stmt->rowCount() > 0) {
        echo "<p>Yards table exists.</p>";
    } else {
        echo "<p style='color:red'>Yards table does not exist!</p>";
    }
    
    // Test the exact query from vehicle_status.php
    echo "<h2>Testing Vehicle Status Query:</h2>";
    
    $sql = "SELECT 
            v.id, 
            v.vehicle_identifier, 
            v.status, 
            v.location_text, 
            v.maintenance_due_date,
            vt.name AS vehicle_type,
            y.name AS yard_name,
            u.name AS assigned_driver,
            (SELECT MAX(m.service_date) FROM maintenance m WHERE m.vehicle_id = v.id AND m.service_type = 'oil_change') AS last_oil_change,
            (SELECT MAX(m.service_date) FROM maintenance m WHERE m.vehicle_id = v.id AND m.service_type = 'tire_rotation') AS last_tire_rotation
        FROM vehicles v
        LEFT JOIN vehicle_types vt ON v.vehicle_type_id = vt.id
        LEFT JOIN yards y ON v.yard_id = y.id
        LEFT JOIN (
            SELECT va.vehicle_id, va.user_id
            FROM vehicle_assignments va
            WHERE va.status = 'active'
        ) current_va ON v.id = current_va.vehicle_id
        LEFT JOIN users u ON current_va.user_id = u.id
        WHERE v.yard_id = ?";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute([1]); // Using yard_id = 1
        $vehicles = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<p>Query executed successfully.</p>";
        echo "<p>Number of vehicles returned: " . count($vehicles) . "</p>";
        
        if (count($vehicles) > 0) {
            echo "<h3>First Vehicle Result:</h3>";
            echo "<pre>";
            print_r($vehicles[0]);
            echo "</pre>";
            
            echo "<h3>JSON Output:</h3>";
            echo "<pre>";
            echo json_encode($vehicles[0], JSON_PRETTY_PRINT);
            echo "</pre>";
        } else {
            echo "<p style='color:red'>No vehicles found with yard_id = 1</p>";
        }
    } catch (PDOException $e) {
        echo "<p style='color:red'>Error executing query: " . $e->getMessage() . "</p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color:red'>Database connection failed: " . $e->getMessage() . "</p>";
}
?>
