<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'db_connect.php';

// Set content type to JSON
header('Content-Type: application/json');

try {
    // Get all users with null created_by
    $stmt = $pdo->prepare("SELECT id, name, email, role FROM users WHERE created_by IS NULL");
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $updatedCount = 0;
    $errors = [];
    
    // Assign created_by values based on role
    foreach ($users as $user) {
        $created_by = null;
        
        // Determine appropriate creator based on role
        switch ($user['role']) {
            case 'yard_manager':
                // Yard managers are created by regional managers (ID 2)
                $created_by = 2;
                break;
            case 'dispatch':
                // Dispatchers are created by yard managers (ID 3)
                $created_by = 3;
                break;
            case 'driver':
            case 'field_rep':
                // Drivers and field reps are created by dispatchers (ID 4)
                $created_by = 4;
                break;
            case 'washcrew':
                // WashCrew members are created by yard managers (ID 3)
                $created_by = 3;
                break;
            default:
                // Skip other roles
                continue;
        }
        
        if ($created_by) {
            try {
                $updateStmt = $pdo->prepare("UPDATE users SET created_by = ? WHERE id = ?");
                $updateStmt->execute([$created_by, $user['id']]);
                
                if ($updateStmt->rowCount() > 0) {
                    $updatedCount++;
                }
            } catch (PDOException $e) {
                $errors[] = "Error updating user {$user['id']} ({$user['name']}): " . $e->getMessage();
            }
        }
    }
    
    echo json_encode([
        'success' => true,
        'message' => "Updated created_by for $updatedCount users",
        'updated_count' => $updatedCount,
        'errors' => $errors
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>
