<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'db_connect.php';

// Set content type to JSON
header('Content-Type: application/json');

try {
    // Check if created_by column exists
    $columnCheckStmt = $pdo->prepare("SHOW COLUMNS FROM users LIKE 'created_by'");
    $columnCheckStmt->execute();
    $columnExists = $columnCheckStmt->rowCount() > 0;
    
    if (!$columnExists) {
        // Add created_by column
        $alterStmt = $pdo->prepare("ALTER TABLE users ADD COLUMN created_by INT NULL, ADD INDEX idx_created_by (created_by)");
        $alterStmt->execute();
        
        echo json_encode(['success' => true, 'message' => 'Added created_by column to users table']);
    } else {
        echo json_encode(['success' => true, 'message' => 'created_by column already exists']);
    }
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>
