<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db_connect.php';

// Set content type to HTML for better readability in browser
header('Content-Type: text/html');

echo "<h1>Update WashCrew Created By</h1>";

// Get yard manager ID from query parameter
$yardManagerId = isset($_GET['yard_manager_id']) ? intval($_GET['yard_manager_id']) : 3; // Default to ID 3 if not specified

try {
    // Find all washcrew users without a created_by value
    $stmt = $pdo->prepare("
        SELECT id, name, email, role, status, created_at, created_by 
        FROM users 
        WHERE role = 'washcrew' AND (created_by IS NULL OR created_by = 0)
    ");
    $stmt->execute();
    $usersToUpdate = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>WashCrew users to update (" . count($usersToUpdate) . " found)</h2>";
    
    if (count($usersToUpdate) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Status</th><th>Created At</th><th>Old Created By</th><th>New Created By</th><th>Status</th></tr>";
        
        $updateStmt = $pdo->prepare("UPDATE users SET created_by = ? WHERE id = ?");
        $updatedCount = 0;
        
        foreach ($usersToUpdate as $user) {
            $updateStmt->execute([$yardManagerId, $user['id']]);
            $status = $updateStmt->rowCount() > 0 ? 'Updated' : 'No change';
            
            if ($status === 'Updated') {
                $updatedCount++;
            }
            
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['id']) . "</td>";
            echo "<td>" . htmlspecialchars($user['name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>" . htmlspecialchars($user['role']) . "</td>";
            echo "<td>" . htmlspecialchars($user['status']) . "</td>";
            echo "<td>" . htmlspecialchars($user['created_at']) . "</td>";
            echo "<td>" . htmlspecialchars($user['created_by'] ? $user['created_by'] : 'NULL') . "</td>";
            echo "<td>" . htmlspecialchars($yardManagerId) . "</td>";
            echo "<td>" . $status . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
        echo "<p>Updated $updatedCount washcrew users to have created_by = $yardManagerId.</p>";
    } else {
        echo "<p>No washcrew users found that need updating.</p>";
    }
    
    // Show all washcrew users
    $allStmt = $pdo->prepare("
        SELECT id, name, email, role, status, created_at, created_by 
        FROM users 
        WHERE role = 'washcrew'
        ORDER BY id
    ");
    $allStmt->execute();
    $allWashcrew = $allStmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>All WashCrew users (" . count($allWashcrew) . " total)</h2>";
    
    if (count($allWashcrew) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Status</th><th>Created At</th><th>Created By</th></tr>";
        
        foreach ($allWashcrew as $user) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['id']) . "</td>";
            echo "<td>" . htmlspecialchars($user['name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>" . htmlspecialchars($user['role']) . "</td>";
            echo "<td>" . htmlspecialchars($user['status']) . "</td>";
            echo "<td>" . htmlspecialchars($user['created_at']) . "</td>";
            echo "<td>" . htmlspecialchars($user['created_by'] ? $user['created_by'] : 'NULL') . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    }
    
    // Add a form to update with a different yard manager ID
    echo "<h2>Update with a different Yard Manager ID</h2>";
    echo "<form method='get'>";
    echo "<p>Enter the ID of the Yard Manager who should be set as the creator of washcrew users:</p>";
    echo "<input type='number' name='yard_manager_id' value='$yardManagerId' min='1'>";
    echo "<input type='submit' value='Update WashCrew Users'>";
    echo "</form>";
    
} catch (PDOException $e) {
    echo "<h2>Error</h2>";
    echo "<p>Database error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
