<?php
require_once '../db_connect.php';
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 7; // Hardcoding Dispatcher One (ID 7) for now, replace with actual auth
$user_role = 'dispatch'; 
// --- End Authentication Placeholder ---

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
    exit;
}

try {
    $role = isset($_GET['role']) ? $_GET['role'] : null;
    
    if (!$role) {
        http_response_code(400);
        echo json_encode(['error' => 'Role parameter is required.']);
        exit;
    }
    
    // Get users by role
    $sql = "SELECT 
                id,
                name,
                email,
                role,
                user_identifier,
                status
            FROM users
            WHERE role = :role
            ORDER BY name";
    
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':role', $role, PDO::PARAM_STR);
    $stmt->execute();
    
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // If no users found, return empty array
    if (empty($users)) {
        echo json_encode([]);
        exit;
    }
    
    echo json_encode($users);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>
