<?php
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db_connect.php';

if (isset($_POST['vehicleId']) && isset($_POST['status'])) {
    $vehicleId = $_POST['vehicleId'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("UPDATE vehicles SET status = ? WHERE id = ?");
    $stmt->execute([$status, $vehicleId]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(array('success' => true, 'message' => 'Vehicle status updated successfully'));
    } else {
        echo json_encode(array('success' => false, 'message' => 'Error updating vehicle status'));
    }
} else {
    echo json_encode(array('success' => false, 'message' => 'Vehicle ID and status are required'));
}