<?php
require_once '../db_connect.php';

header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

// Get the request body
$data = json_decode(file_get_contents('php://input'), true);

// Check if data is valid
if (!$data) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Invalid request data']);
    exit();
}

// In a real implementation, you would insert the data into the database
// For now, we'll just return a success response with the data
$newAsset = $data;
$newAsset['id'] = rand(100, 999); // Generate a random ID
$newAsset['lastUpdated'] = date('Y-m-d\TH:i:s');

// Return the new asset as JSON
echo json_encode(['success' => true, 'data' => $newAsset]);

// Close the database connection
$conn->close();
?>
