<?php
require_once '../db_connect.php';

header('Content-Type: application/json');

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

// Check if asset_id is provided
if (!isset($_GET['asset_id'])) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Asset ID is required']);
    exit();
}

$assetId = $_GET['asset_id'];

// Mock inspection history data
$inspectionHistory = [
    1 => [
        [
            'id' => 1,
            'date' => '2023-05-15',
            'inspector' => 'David Johnson',
            'result' => 'Pass',
            'notes' => 'All systems functioning properly'
        ]
    ],
    2 => [
        [
            'id' => 2,
            'date' => '2023-04-20',
            'inspector' => 'Lisa Anderson',
            'result' => 'Pass with notes',
            'notes' => 'Minor rust on undercarriage, not structural'
        ]
    ],
    3 => [
        [
            'id' => 3,
            'date' => '2023-03-05',
            'inspector' => 'Michael Brown',
            'result' => 'Fail',
            'notes' => 'Hydraulic system issues, needs maintenance before returning to service'
        ]
    ]
];

// Check if inspection history exists for the asset
if (!isset($inspectionHistory[$assetId])) {
    // Return empty array if no inspection history found
    echo json_encode(['success' => true, 'data' => []]);
    exit();
}

// Return the inspection history as JSON
echo json_encode(['success' => true, 'data' => $inspectionHistory[$assetId]]);

// Close the database connection
$conn->close();
?>
